/*** 1.   ũƮ ***/

SELECT rownum AS seq
	, NEWID() AS sub_code
	, DATEADD(ss,rownum,'2020-01-01 00:00:00.000') AS date 
INTO TB_Sub05
FROM (SELECT ROW_NUMBER() OVER (ORDER BY A.number) AS rownum, A.number
	 FROM master..spt_values A 
	 JOIN master..spt_values B 
	 ON A.type = 'P' AND B.type = 'P' AND A.number <= 1000 AND B.number <= 1000
) A

SELECT sub_code AS main_code
	, CASE WHEN seq < 30000 THEN 11 ELSE CAST(seq%10 AS INT) END AS value 
INTO TB_Main05 
FROM TB_Sub05

CREATE CLUSTERED INDEX CIDX_Main05 ON TB_Main05(main_code)
CREATE INDEX NIDX01_Main05 ON TB_Main05(value)
CREATE CLUSTERED INDEX CIDX_Sub05 ON TB_Sub05(date) 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT *, (SELECT sub_code 
	      FROM TB_Sub05 
	      WHERE sub_code = A.main_code 
	      AND date BETWEEN '2020-01-01 00:09:00.000' AND '2020-01-01 00:20:00.000')
FROM TB_Main05 A
WHERE A.value = 11
GO


/*** 6. [TO-BE]   ***/

--(1) Į   DISTINCT ߰
SELECT *, (SELECT DISTINCT sub_code 
	      FROM TB_Sub05 
	      WHERE sub_code = A.main_code 
	      AND date BETWEEN '2020-01-01 00:09:00.000' AND '2020-01-01 00:20:00.000')
FROM TB_Main05 A
WHERE A.value = 11
GO

--(2) Į  LEFT OUTER JOIN 
SELECT * 
FROM TB_Main05 A
LEFT OUTER JOIN (SELECT sub_code 
				FROM TB_Sub05  
				WHERE date BETWEEN '2020-01-01 00:09:00.000' 
					AND '2020-01-01 00:20:00.000') B 
ON A.main_code = B.sub_code
WHERE A.value = 11
GO